//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Text;
namespace Testing
{
	class ArrayMain
	{
		static void Single()
		{
			// Deklaracja tablicy 
			int [] a = new int[10];
			for(int i = 0; i < a.Length; i++)
				a[i] = i;
			// Inicjalizacja i deklaracja w jednym wierszu
			int [] b = new int [] {0, 1, 2 ,3 ,4 ,5, 6, 7, 8, 9};
			Console.WriteLine("{0} {1} {2}", a.Equals(b), a.Length, b.Length);
			// Skopiowanie dwch elementw z 'a' poczwszy od indeksu 5 do 
			// 'b' poczwszy od indeksu 0.
			Array.Copy(a, 5, b, 0, 2);
			foreach(int i in b)
				Console.WriteLine("{0}", i);
			// Utworzenie tablicy cigw
			string [] c = new string [] {"Poniedziaek", "Wtorek", "roda", "Czwartek", "Pitek", "Sobota", "Niedziela"};
			// Ptla dla tablicy cigw
			foreach(string s in c)
				Console.WriteLine("{0}", s);
		}
		static void Multiple()
		{
			// Deklaracja wielowymiarowej tablicy
			int [,] a = new int[5,5];
			for(int i = 0; i < a.GetLength(0); i++)
				for(int j = 0; j < a.GetLength(1); j++)
					a[i,j] = i * a.GetLength(1) + j;
			// Inicjalizacja i deklaracja w jednym wierszu
			int [,] b = new int [,] {{0, 0, 0, 0, 0},
									 {1, 1, 1, 1, 1},
									 {2, 2, 2, 2, 2},
									 {3, 3, 3, 3, 3},
									 {4, 4, 4, 4, 4}};
			Console.WriteLine("{0} {1} wymiary {2}x{3} {4}x{5}", a.Equals(b),
				                                                    a.Rank,
				                                                    a.GetLength(0),
				                                                    a.GetLength(1),
				                                                    b.GetLength(0),
				                                                    b.GetLength(1));
			
			Array.Copy(a, 5, b, 5, 5);
			for(int i = 0; i < a.GetLength(0); i++)
			{
				for(int j = 0; j < a.GetLength(1); j++)
				{
					Console.Write("{0}", b[i,j]);
				}
				Console.WriteLine();
			}
			// Utworzenie dwuwymiarowej tablicy cigw
			string [,] c = new string [,]{{"0 - Poniedziaek",
										   "0 - Wtorek",
										   "0 - roda",
										   "0 - Czwartek",
										   "0 - Pitek",
										   "0 - Sobota",
										   "0 - Niedziela"},
										  {"1 - Poniedziaek",
										   "1 - Wtorek",
										   "1 - roda",
										   "1 - Czwartek",
										   "1 - Pitek",
										   "1 - Sobota",
										   "1 - Niedziela"}};
			// Ptla dla tablicy
			foreach(string s in c)
					Console.WriteLine(s);
			int [,,,] d = new int [5,5,5,5];
			Console.WriteLine("{0} wymiary", d.Rank);
		}
		static void Jagged()
		{
			// Deklaracja wielowymiarowej tablicy
			int [][] a = new int[5][];
			for(int i = 0; i < a.Length; i++)
				a[i] = new int [i + 1];
			for(int i = 0; i < a.Length; i++)
			{
				for(int j = 0; j < a[i].Length; j++)
				{
					a[i][j] = i;
				}
			}
			foreach(int [] ia in a)
			{
				foreach(int i in ia)
					Console.Write("{0}", i);
				Console.WriteLine();
			}
			// Inicjalizacja i deklaracja w jednym wierszu
			int [][] b = {new int [] {0},
						  new int [] {1, 1},
						  new int [] {2, 2, 2},
						  new int [] {3, 3, 3, 3},
						  new int [] {4, 4, 4, 4, 4}};
			foreach(int [] ia in b)
			{
				foreach(int i in ia)
					Console.Write("{0}", i);
				Console.WriteLine();
			}
		}
		static void Main(string[] args)
		{
			Single();
			Multiple();
			Jagged();
		}
	}
}
